import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'

const ratioValue = 56.25

const Ratio = styled.div`
	position: relative;
	padding-bottom: ${ratioValue}%;
	background: black;

	/* for some reason styles from iframe
		were propagated to section above DOM.
		This fixes it instead of styling iframe directly */
	& iframe {
		width: 100%;
		height: 100%;
		position: absolute;
	}
`

const YoutubeVideoWidget = ({ id, site }) => {
	return (
		<Ratio>
			<iframe
				title={`youtube-${id}`}
				src={`//${site}/video/embed/${id}?autoplay=true&pageType=clip`}
			/>
		</Ratio>
	)
}

YoutubeVideoWidget.propTypes = {
	id: PropTypes.string.isRequired,
	site: PropTypes.string.isRequired,
}

export default YoutubeVideoWidget
