/* eslint-disable react/no-unused-prop-types */
import React from 'react'
import Proptypes from 'prop-types'
import VideoEmbed from '../embed'
import { parseCustom } from '../../../utils/video/parse-custom'
import BlinkLabrador from '../../BlinkLabrador'
import BlinkIframeVideoTracking from '../../BlinkLabrador/iframe'

class JWVideoWidget extends React.Component {
	componentDidMount() {
		const { id, custom, promoted, device, autoplay } = this.props
		const { plussproductid } = parseCustom(custom)

		if (window.player) {
			window.player({ id, plussproductid, promoted, device, isEmbedExternally: false, autoplay })
		} else {
			window.addEventListener('videoAssetsLoaded', () => {
				window.player({ id, plussproductid, promoted, device, isEmbedExternally: false, autoplay })
			})
		}
	}

	componentWillUnmount() {
		const { id } = this.props

		if (window.jwplayer && window.jwplayer(id)) {
			window.jwplayer().remove()
		}
	}

	render() {
		const {
			id,
			videoImage: { medium },
			custom,
			isIframe,
		} = this.props
		const { plussproductid } = parseCustom(custom)

		return (
			<>
				<VideoEmbed
					videoId={id}
					plussproductid={plussproductid}
					image={medium}
					doInit={false}
					isIframe={isIframe}
					isEmbedExternally={false}
				/>
				{isIframe ? <BlinkIframeVideoTracking /> : <BlinkLabrador />}
			</>
		)
	}
}

export default JWVideoWidget

export const videoWidgetProps = {
	id: Proptypes.string.isRequired,
	isIframe: Proptypes.bool,
	promoted: Proptypes.arrayOf(
		Proptypes.shape({
			id: Proptypes.string,
		}),
	).isRequired,
	custom: Proptypes.string,
	/** autoplay prop overrides autoplay from default player settings */
	autoplay: Proptypes.bool,
}

JWVideoWidget.propTypes = {
	...videoWidgetProps,
}

JWVideoWidget.defaultProps = {
	custom: null,
	autoplay: undefined,
}
