import React from 'react'
import PropTypes from 'prop-types'

import VideoPlaceholder from './placeholder'
import { PlayerScript, PlayerInitScript, AssetsScript } from './scripts'

const VideoEmbedWithScripts = ({ id, isSticky, playerId, withPrebid, image, doInit, isIframe }) => {
	return (
		<>
			<VideoPlaceholder id={id} isSticky={isSticky} image={image} isIframe={isIframe} />
			{playerId && <PlayerScript id={playerId} />}
			<AssetsScript />
			{doInit && <PlayerInitScript videoId={id} isSticky={isSticky} withPrebid={withPrebid} />}
		</>
	)
}

const VideoEmbedWithScriptsPropTypes = {
	id: PropTypes.string.isRequired,
	playerId: PropTypes.string,
	isSticky: PropTypes.bool,
	withPrebid: PropTypes.bool,
	image: PropTypes.string,
	doInit: PropTypes.bool,
	isIframe: PropTypes.bool,
}

const VideoEmbedWithScriptsDefaultProps = {
	isSticky: false,
	playerId: null,
	withPrebid: false,
	image: null,
	doInit: true,
	isIframe: false,
}

VideoEmbedWithScripts.propTypes = VideoEmbedWithScriptsPropTypes

VideoEmbedWithScripts.defaultProps = VideoEmbedWithScriptsDefaultProps

export default VideoEmbedWithScripts
export { VideoEmbedWithScriptsPropTypes, VideoEmbedWithScriptsDefaultProps }
