import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'

import { VideoEmbedPropTypes, VideoEmbedDefaultProps } from './prop-types'
import VideoEmbed from './index'
import Headline from '../../SkiStarPlug/Headline'
import ArticlePreviewText from '../../SkiStarPlug/ArticlePreviewText'
import { fillEmptyGridSizes } from '../../SkiStarPlug/get-grid-sizes'

const VideoPlugHeadline = styled(Headline)`
	color: black;
`

const VideoEmbedWithDetails = ({ videoId, playerId, title, column, image }) => {
	return (
		<>
			<VideoEmbed videoId={videoId} playerId={playerId} image={image} />
			<ArticlePreviewText>
				<VideoPlugHeadline {...fillEmptyGridSizes(column)}>{title}</VideoPlugHeadline>
			</ArticlePreviewText>
		</>
	)
}

VideoEmbedWithDetails.propTypes = {
	...VideoEmbedPropTypes,
	title: PropTypes.string.isRequired,
}

VideoEmbedWithDetails.defaultProps = VideoEmbedDefaultProps

export default VideoEmbedWithDetails
