import React from 'react'

import styled from 'styled-components'
import Sticky from '../Sticky'
import JWStyler from './JWStyler'
import UnmuteButton from '../UnmuteButton'
import { VideoEmbedPropTypes, VideoEmbedDefaultProps } from './prop-types'

// For some reason, styled components deletes
// div in current hierarchy for video iframe,
// so, changing ratioHandler from div to section
// so, it would not be deleted

// setting placeholder of a video with a correct width-to-height ratio
const VideoRatioHandler = styled.section`
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
`

// We need additional styled div because when JW instantiates player
// It replaces all classnames to `jw-*` ones.
const VideoPlaceholder = ({ videoId, isSticky, image, isIframe }) => (
	<JWStyler
		data-videoid={videoId}
		data-sticky={isSticky}
		data-is-iframe={isIframe ? 1 : 0}
		image={image}
	>
		<VideoRatioHandler>
			<Sticky isSticky={isSticky}>
				<UnmuteButton />
				{/* data-videoid is needed for blink-labrador tracking initialization */}
				<div id={videoId} />
			</Sticky>
		</VideoRatioHandler>
	</JWStyler>
)

VideoPlaceholder.propTypes = VideoEmbedPropTypes
VideoPlaceholder.defaultProps = VideoEmbedDefaultProps

export default VideoPlaceholder
