import React from 'react'
import PropTypes from 'prop-types'

import PlugLink from '../../SkiStarPlug/PlugLink'
import { SkistarArticle } from '../../SkiStarPlug/ArticleCol'
import VideoEmbedWithDetails from './withDetails'

const VideoPlug = ({ videoID, playerID, imageURL, title, column, topnormal }) => {
	const fontColumn = column
	if (topnormal) {
		column = {
			xs: 12,
			sm: 12,
			md: 12,
			lg: 12,
		}
	}
	return (
		<SkistarArticle
			style={{ marginBottom: '1.3rem' }}
			className="preview-blink lp_article"
			{...column}
		>
			<PlugLink>
				<VideoEmbedWithDetails
					videoId={videoID}
					title={title}
					column={fontColumn}
					playerId={playerID}
					image={imageURL}
				/>
			</PlugLink>
		</SkistarArticle>
	)
}

VideoPlug.propTypes = {
	videoID: PropTypes.string.isRequired,
	playerID: PropTypes.string.isRequired,
	imageURL: PropTypes.string.isRequired,
	title: PropTypes.string.isRequired,
	column: PropTypes.shape({}),
	topnormal: PropTypes.bool.isRequired
}

VideoPlug.defaultProps = {
	column: { xs: 100 }
}

export default VideoPlug
