/* eslint-disable react/no-multi-comp */
import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'

import { TrysilPlug } from '@aller/shiny/src/molecules/TrysilPlug'
import { Carousel } from '@aller/shiny/src/molecules/Carousel'
import { PlussLabel } from '@aller/shiny/src/atoms/PlussLabel'

import { OverlayingImageLabels } from '@aller/shiny/src/molecules/OverlayingImageLabels'
import { VideoPlugHeading } from '../VideoHeading/VideoPlugHeading'
import { parseCustom } from '../../utils/video/parse-custom'

import VideoHeading from '../VideoHeading'

const StyledCarousel = styled(Carousel)`
	margin-top: ${props => (props.vertical ? '0' : '1rem')};
`

const VideoCarousel = ({
	label,
	videos,
	vertical,
	hideButtons,
	carouselHeadingProps,
	headingComponent,
	text,
	...props
}) => {
	const Heading = props => (
		<VideoHeading
			headingComponent={headingComponent}
			headingProps={carouselHeadingProps}
			title={text}
			{...props}
		/>
	)
	if (!videos || !videos.length) return null
	const video = videos.map(v => {
		const isPlussVideo = !!parseCustom(v.custom).plussproductid
		return (
			<React.Fragment key={v.title}>
				<TrysilPlug
					title={v.title}
					sources={v.thumbnail.sources}
					placeholderUrl={v.thumbnail.placeholder}
					url={v.url}
					image={v.videoImage.medium}
					imageProps={{ expand: 50 }}
					ratio={v.thumbnail.aspectRatio}
					Heading={headingProps => (
						<VideoPlugHeading maxLines={2} size="xsmall" {...headingProps} />
					)}
					headingProps={carouselHeadingProps}
					Labels={OverlayingImageLabels}
					labelsProps={{ order: 2 }}
					// eslint-disable-next-line react/jsx-no-duplicate-props
					labels={
						v.show && [
							{
								src: v.show.icon,
								alt: v.show.title,
								width: '3rem',
								height: '3rem',
							},
						]
					}
				/>
				{isPlussVideo && <PlussLabel absolute top="0.5rem" left="0.5rem" />}
			</React.Fragment>
		)
	})
	return (
		<StyledCarousel
			heading={label.toUpperCase()}
			// eslint-disable-next-line react/jsx-no-duplicate-props
			Heading={Heading}
			vertical={vertical}
			hideButtons={hideButtons}
			horizontalArrowOffset="-7rem"
			{...props}
		>
			{video}
		</StyledCarousel>
	)
}

VideoCarousel.propTypes = {
	label: PropTypes.oneOfType([PropTypes.string, PropTypes.element]).isRequired,
	vertical: PropTypes.bool,
	hideButtons: PropTypes.bool,
	text: PropTypes.string,
	headingComponent: PropTypes.string.isRequired,
	carouselHeadingProps: PropTypes.shape({
		ALLCAPS: PropTypes.bool,
		marginTopFactor: PropTypes.number,
	}),
	videos: PropTypes.arrayOf(
		PropTypes.shape({
			title: PropTypes.string.isRequired,
			url: PropTypes.string.isRequired,
			videoImage: PropTypes.shape({
				low: PropTypes.string,
				medium: PropTypes.string,
			}),
		}),
	),
}
VideoCarousel.defaultProps = {
	vertical: false,
	hideButtons: false,
	videos: [],
	carouselHeadingProps: {
		ALLCAPS: false,
	},
	text: '',
}

export default VideoCarousel
