import React from 'react'
import dynamic from 'next/dynamic'
import styled, { keyframes } from 'styled-components'
import { Button } from '@aller/shiny/src/atoms/Button'
import { getColor } from '@aller/shiny/src/utils/get-color'

// NOTE: all styles are used in labrador contentboxes,
// so dimentions should be in px, not rem

// by default button is hidden
// top:, left: percentage values taken considering player resize
const StyledButton = styled(Button)`
	display: none;
	top: 15%;
	left: 2%;
	height: 40px;
	font-size: 16px;
	position: absolute;
	background: none;
	overflow: hidden;
	margin: 0;
	z-index: 10;
	font-weight: bold;
	letter-spacing: 0.1px;
	padding: 0;

	&:hover {
		box-shadow: 0 0 1px 1px ${getColor('darknessLight')};
	}

	& > * {
		height: inherit;
	}
`

const IconFadeInAnimation = keyframes`
from {
	opacity: 0;
}

to {
	opacity: 1;
}
`

// appears, shows for 80% of duration and hides back
const titleDisplayAnimation = keyframes`
from {
	width: 0;
	opacity: 0;
}

10% {
	width: 100px;
	opacity: 1;
}

90% {
	width: 100px;
	opacity: 1;
}

to {
	width: 0;
	opacity: 0;
}
`

const easeOutQuadEasing = 'cubic-bezier(0.25, 0.46, 0.45, 0.94)'

const Title = styled.div`
	background: ${getColor('white')};
	display: flex;
	align-items: center;
	justify-content: center;
	position: relative;
	pointer-events: none;
	white-space: nowrap;
	width: 0;
	opacity: 0;

	animation: 5s ${easeOutQuadEasing} 0.3s ${titleDisplayAnimation};
`

const NoSoundIcon = dynamic(() =>
	import(/* webpackChunkName: "NoSound" */ '@aller/shiny/src/atoms/SvgIcon/default/NoSound'),
)

const SvgIconWrapper = dynamic(() =>
	import(
		/* webpackChunkName: "SvgIconWrapper" */ '@aller/shiny/src/atoms/SvgIcon/SvgIconWrapper'
	).then(c => c.SvgIconWrapper),
)

const StyledIconWrapper = styled(SvgIconWrapper)`
	z-index: 10;
	display: flex;
	align-items: center;
	width: 40px;

	animation: 300ms ${easeOutQuadEasing} 0s ${IconFadeInAnimation};
`

export default props => {
	return (
		<StyledButton className="unmute-btn" textColor="darkness" {...props}>
			<StyledIconWrapper>
				<NoSoundIcon />
			</StyledIconWrapper>
			<Title>Skru På Lyd</Title>
		</StyledButton>
	)
}
