import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'

import CloseStickyButton from './close-sticky-button'

const StyledPlayerWrapper = styled.section`
	&&.player-minimize {
		bottom: 2rem;
		right: 2rem;
		position: fixed;
		width: 34rem;
		z-index: 1010;

		.jw-title-primary {
			font-size: 1.5rem;
		}

		> div {
			padding: 0.5rem;
			background-color: white;
			box-shadow: 0.1rem 0.1rem 2.15rem 4px rgba(0, 0, 0, 0.3);
		}

		.close-sticky-btn {
			display: block;
		}
	}
`

const Sticky = ({ children, isSticky }) => (
	<StyledPlayerWrapper className="sticky-section">
		{isSticky && <CloseStickyButton />}
		<div>{children}</div>
	</StyledPlayerWrapper>
)

Sticky.propTypes = {
	children: PropTypes.node.isRequired,
	isSticky: PropTypes.bool.isRequired,
}

export default Sticky
