import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { Kicker } from '@aller/shiny/src/atoms/Kicker'
import { Image } from '@aller/shiny/src/atoms/Image'

const MarketingKicker = styled(Kicker)`
	height: calc(2.5 * ${getVariable('verticalBase')});
	display: flex;
	justify-content: space-between;
	align-items: center;
	padding: calc(0.2 * ${getVariable('verticalBase')}) ${getVariable('horizontalBase')};
	border-top: 0.5rem solid ${getColor('teal')};
	border-bottom: 1px solid ${getColor('grayTintLight')};
`

const MarketingLogo = styled(Image)`
	height: 100%;
	object-fit: contain;
	width: initial;
	padding-left: calc(0.5 * ${getVariable('horizontalBase')});
`

const MarketingVideoStrip = ({ logo }) => {
	return (
		<MarketingKicker backgroundColor="white" textColor="darkness">
			ANNONSØRINNHOLD
			{logo && <MarketingLogo src={logo} />}
		</MarketingKicker>
	)
}

MarketingVideoStrip.propTypes = {
	logo: PropTypes.string,
}

MarketingVideoStrip.defaultProps = {
	logo: undefined,
}

export default MarketingVideoStrip
