import React from 'react'
import PropTypes from 'prop-types'
// see next.config.js for components that does this
export default class NoReHydration extends React.Component {
	// not update either! No inital rendering and no update!
	shouldComponentUpdate() {
		return false
	}

	render() {
		const { elementName } = this.props
		// Since we are one the client
		// and we are trying to render something with dangerouslySetInnerHTML react does not
		// rehydrate this. Even if our original component was a advanced reactcomponent
		// More info: https://github.com/reactjs/rfcs/pull/46
		return React.createElement(elementName, {
			dangerouslySetInnerHTML: { __html: '', suppressHydrationWarning: true },
		})
	}
}

NoReHydration.propTypes = {
	elementName: PropTypes.string,
}

NoReHydration.defaultProps = {
	elementName: 'div',
}
