/* eslint-disable import/prefer-default-export */
import styled, { css } from 'styled-components'
import { SmallLinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'

// this wrapper can be useful for wrapping logo in headers
// resolves the issue with header height in IE11
// using in: DagbladetHeader, DinsideHeader

export const LogoLink = styled(SmallLinkBarLink)`
	${props => {
		return css`
			height: 100%;
			max-width: ${props.smSize ? props.smSize : '14.8'}rem;
			@media screen and (min-width: ${props.theme.flexboxgrid.breakpoints.sm}em) {
				height: 6rem;
				max-width: 14.8rem;
				margin-right: ${props.marginRight ? props.marginRight : 0}rem;
			}
		`
	}}
`
