import styled from 'styled-components'
import React from 'react'
import PropTypes from 'prop-types'

/* eslint-disable react/no-danger */
/**
 * Vanilla js extender for LinkBarDropdown components.
 *
 * The dropdown functionality is recreated with
 * vanilla, no-react javascript, so that we can
 * serve these components as Edge Side Includes
 * on pages that do not necessarily run React.
 *
 * @param id required It's an HTML id
 * @param Dropdown required The LinkBarDropdown element to extend
 */
const VanillaDropdown = ({ id, Dropdown, ...rest }) => {
	const StyledDropdown = styled(Dropdown)`
		&.toggled ~ div {
			display: block;
		}
	`
	return (
		<>
			<StyledDropdown id={id} {...rest} />
			<script
				dangerouslySetInnerHTML={{
					__html: `
					if (typeof toggleVanillaClick === "undefined") {
						function toggleVanillaClick(){
							this.classList.toggle('toggled');
							this.setAttribute('aria-expanded', this.getAttribute('aria-expanded') === "false");
						}
					}
					if (typeof initDropdown === "undefined") {
						function initDropdown(id) {

							const element = document.getElementById(id)
							element.addEventListener('click', toggleVanillaClick.bind(element));

							element.parentElement.addEventListener('focusin', function() {
								element.dataset.lastFocusTime = Date.now();
							});

							element.parentElement.addEventListener('focusout', function() {
								const delay = 100; // milliseconds;
								setTimeout(
									function() {
										Date.now() - parseInt(element.dataset.lastFocusTime) > delay && element.classList.remove('toggled')
									},
									delay
								);
							});
						}
					}

					initDropdown('${id}');
					`,
				}}
			/>
		</>
	)
}
VanillaDropdown.propTypes = {
	id: PropTypes.string.isRequired,
	Dropdown: PropTypes.oneOfType([
		PropTypes.func,
		PropTypes.shape({
			render: PropTypes.func,
		}),
	]).isRequired,
}

export default VanillaDropdown
