import React from 'react'
import styled, { withTheme } from 'styled-components'
import PropTypes from 'prop-types'
import { FontIcon } from '@aller/shiny/src/atoms/FontIcon'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { Truncate } from '@aller/shiny/src/atoms/Truncate'
import { SvgIcon } from '@aller/shiny/src/atoms/SvgIcon'
import { IconButton } from './IconButton'

const StyledSvgIcon = styled(SvgIcon)`
	margin-left: calc(${getVariable('horizontalBase')} / 4);
`

export const Icon = styled(FontIcon)`
	&& {
		margin-left: calc(${getVariable('horizontalBase')} / 2);
	}
`

export const TruncatedTrigger = withTheme(props => {
	const { linkText, hide, selector, ...rest } = props
	const direction = hide === true ? 'down' : 'up'
	return (
		<IconButton {...rest}>
			<Truncate maxWidth="14rem">
				<span id={`${selector}-dropdown-button`}>{linkText}</span>
			</Truncate>
			<Icon name={`arrow-alt-${direction}`} size={1} />
		</IconButton>
	)
})

export const MobileMenuTrigger = props => {
	const { linkText, hide, ...rest } = props

	return (
		<IconButton {...rest}>
			{linkText} <StyledSvgIcon opened={!hide} name="hamburger" size={2.5} color="white" />
		</IconButton>
	)
}

const propTypes = {
	linkText: PropTypes.string,
	selector: PropTypes.string,
	hide: PropTypes.bool,
}

MobileMenuTrigger.propTypes = { ...propTypes }
MobileMenuTrigger.defaultProps = { hide: true }
TruncatedTrigger.propTypes = { ...propTypes }
TruncatedTrigger.defaultProps = { hide: true }
