import React from 'react'
import PropTypes from 'prop-types'
import dynamic from 'next/dynamic'

const BrandBar = dynamic(() =>
	import(/* webpackChunkName: "BrandBar" */ './SOLComponents/BrandBar'),
)
const CategoryBar = dynamic(() =>
	import(/* webpackChunkName: "CategoryBar" */ './SOLComponents/CategoryBar'),
)
const SOLHeader = ({ path }) => (
	<header className="lp_header">
		<BrandBar />
		<CategoryBar path={path} />
	</header>
)

SOLHeader.propTypes = {
	path: PropTypes.string,
}

SOLHeader.defaultProps = {
	path: '',
}

export default SOLHeader
