import React from 'react'
import propTypes from 'prop-types'

const TheWeek = ({ datetime }) => {
	const { week } = datetime

	return <span>{week}</span>
}

TheWeek.propTypes = {
	datetime: propTypes.shape({
		week: propTypes.string,
	}),
}

TheWeek.defaultProps = {
	datetime: {
		week: '',
	},
}

export default TheWeek
