import React from 'react'
import propTypes from 'prop-types'
import styled from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

import getNewDateTime from './getNewDateTime'
import TheDate from './TheDate'
import TheWeek from './TheWeek'
import TheTime from './TheTime'

const minWidth = 657

const FormattedTime = styled.time`
	display: none;
	color: ${getColor('white')};
	flex-grow: 1;
	padding: 0 ${getVariable('horizontalBase')};
	font-size: ${getVariable('uiRegularSize')};
	line-height: ${getVariable('uiRegularLineHeight')};
	position: relative;
	top: -1px;

	@media (min-width: ${minWidth}px) {
		display: inline;
	}
`

class FormattedDateAndTime extends React.Component {
	constructor(props) {
		super(props)

		const { preventUpdate } = props

		this.state = {
			datetime: preventUpdate ? getNewDateTime(49020000) : getNewDateTime(),
		}
	}

	componentDidMount() {
		const { preventUpdate } = this.props
		const { datetime: stateDatetime } = this.state

		if (window.innerWidth <= minWidth - 1) {
			return
		}

		this.timerID = setInterval(() => {
			const datetime = preventUpdate ? getNewDateTime(49020000) : getNewDateTime()

			if (stateDatetime.time !== datetime.time) {
				this.setState({ datetime })
			}
		}, 1000)
	}

	shouldComponentUpdate(nextProps, nextState) {
		const { datetime } = this.state
		return datetime.time !== nextState.datetime.time
	}

	componentWillUnmount() {
		clearInterval(this.timerID)
	}

	render() {
		const { datetime } = this.state

		return (
			<FormattedTime>
				<TheDate datetime={datetime} />
				{' ・ '}
				<TheWeek datetime={datetime} />
				{' ・ '}
				<TheTime datetime={datetime} />
			</FormattedTime>
		)
	}
}
FormattedDateAndTime.propTypes = {
	preventUpdate: propTypes.bool,
}
FormattedDateAndTime.defaultProps = {
	preventUpdate: false,
}

export default FormattedDateAndTime
