import React from 'react'
import propTypes from 'prop-types'
import styled, { withTheme } from 'styled-components'
import menuContent from 'sol-menu-content'

import { LinkBarLink as OverrideSolsOldBaseRigLink } from '@aller/shiny/src/atoms/LinkBarLink'

import { ScrollArrowsLinkBar as ShinyScrollBar } from '@aller/shiny/src/molecules/ScrollArrowsLinkBar'
import { LinkBarHeading } from '@aller/shiny/src/atoms/LinkBarHeading'

import { getColor } from '@aller/shiny/src/utils/get-color'

const LinkBarLink = styled(OverrideSolsOldBaseRigLink)`
	margin: 0;
	a {
		margin: 0;
	}
`

const ScrollArrowsLinkBar = styled(ShinyScrollBar)`
	overflow: -moz-scrollbars-none;
`

const isLowerCaseEqual = (str1, str2) => {
	return str1.toLowerCase() === str2.toLowerCase()
}

const CategoryBar = props => {
	const { path } = props
	const items = JSON.parse(menuContent).main

	return (
		<ScrollArrowsLinkBar
			background={`linear-gradient(0deg, ${getColor('grayTint')(props)}, ${getColor('white')(
				props,
			)} .1rem)`}
			shouldAdjustForNestedPadding
			drawRightArrowInitially
		>
			{items.map((item, i) => {
				if (item.type && item.type === 'heading') {
					return <LinkBarHeading key={i}>{item.title}</LinkBarHeading>
				}

				return (
					<LinkBarLink
						key={i}
						isActive={isLowerCaseEqual(item.uri, path)}
						linkText={item.title}
						className={`lp_submenu_${item.title}`}
						style={{ zIndex: 5 }}
						url={item.uri}
					/>
				)
			})}
		</ScrollArrowsLinkBar>
	)
}

CategoryBar.contextTypes = {
	settings: propTypes.shape({
		route: propTypes.string,
		ua: propTypes.shape({
			isDesktop: propTypes.bool,
		}),
	}),
}

CategoryBar.propTypes = {
	path: propTypes.string,
}

CategoryBar.defaultProps = {
	path: '',
}

export default withTheme(CategoryBar)
