import React from 'react'
import styled, { withTheme } from 'styled-components'
import PropTypes from 'prop-types'
import { FontIcon } from '@aller/shiny/src/atoms/FontIcon'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { Truncate } from '@aller/shiny/src/atoms/Truncate'
import { SvgIcon } from '@aller/shiny/src/atoms/SvgIcon'
import { IconButton } from './IconButton'

const StyledSvgIcon = styled(SvgIcon)`
	margin-left: calc(${getVariable('horizontalBase')} * 1 / 2);
`
export const Icon = styled(FontIcon)`
	&& {
		margin-left: calc(${getVariable('horizontalBase')} / 2);
	}
`
const StyledIconButton = styled(IconButton)`
	padding-right: 0.7rem;
`
export const TruncatedTrigger = withTheme(props => {
	const { linkText, hide, theme, selector, ...rest } = props
	const direction = hide === true ? 'down' : 'up'
	return (
		<StyledIconButton {...rest}>
			<Truncate
				maxWidth="20rem"
				custom={[
					{
						screenWidth: '90rem',
						maxWidth: `calc(${getVariable('horizontalBase')({ theme })} * 10)`,
					},
					{
						screenWidth: `${theme.flexboxgrid.breakpoints.sm}rem`,
						maxWidth: `calc(${getVariable('horizontalBase')({ theme })} * 5)`,
					},
				]}
			>
				<span id={`${selector}-dropdown-button`}>{linkText}</span>
			</Truncate>
			<Icon name={`arrow-alt-${direction}`} size={1} />
		</StyledIconButton>
	)
})
export const Trigger = props => {
	const { linkText, hide, ...rest } = props
	const direction = hide === true ? 'down' : 'up'

	return (
		<IconButton {...rest}>
			{linkText}
			<Icon name={`arrow-alt-${direction}`} size={1} />
		</IconButton>
	)
}

const MobileIconButton = styled(IconButton)`
	padding-left: 0.7rem;
`

export const MobileMenuTrigger = props => {
	const { linkText, hide, ...rest } = props

	return (
		<MobileIconButton {...rest}>
			{linkText} <StyledSvgIcon opened={!hide} name="hamburger" size={2.15} color="white" />
		</MobileIconButton>
	)
}
const propTypes = {
	linkText: PropTypes.string,
	selector: PropTypes.string,
	hide: PropTypes.bool,
}
MobileMenuTrigger.propTypes = { ...propTypes }
MobileMenuTrigger.defaultProps = { hide: true }
Trigger.propTypes = { ...propTypes }
Trigger.defaultProps = { hide: true }
TruncatedTrigger.propTypes = { ...propTypes }
TruncatedTrigger.defaultProps = { hide: true }
