import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'
import { getColor, getVariable } from '@aller/shiny/src/utils'
import { FontIcon } from '@aller/shiny/src/atoms/FontIcon'
import { LinkBarDropdown } from '@aller/shiny/src/atoms/LinkBarDropdown'
import { IconButton } from './IconButton'
import DesktopMenu, { ImportantLabel } from './DesktopMenu'
import MobileMenuLink from './MobileMenuLink'
import withBorder from './withBorder'

const Button = withBorder(['bottom'])(styled(IconButton)`
	&& {
		width: 100%;
		justify-content: space-between;
		color: ${getColor('primary')};
		font-weight: ${getVariable('uiWeightBold')};
		line-height: ${getVariable('uiSmallLineHeight')};
		text-transform: uppercase;
	}
`)

const Trigger = ({ linkText, hide, ...rest }) => (
	<Button {...rest}>
		{linkText}
		<FontIcon size={1.2} name={`arrow-alt-${hide ? 'down' : 'up'}`} />
	</Button>
)
Trigger.propTypes = {
	hide: PropTypes.bool,
	linkText: PropTypes.string,
}
Trigger.defaultProps = {
	hide: false,
	linkText: '',
}

const linkProps = {
	activeTextColor: 'darkness',
	textColor: 'darkness',
	ALLCAPS: false,
	useUnderline: false,
	size: 'large',
}

const MobileMenu = ({ data }) => {
	return (
		<>
			{data.map(({ title, data }) => (
				<LinkBarDropdown
					key={title}
					linkText={title}
					Trigger={Trigger}
					useUnderline={false}
					activeBackgroundColor="white"
					size="large"
				>
					{data.map(({ title, url, color, important }) => (
						<MobileMenuLink {...linkProps} textColor={color} key={title} url={url}>
							{title}
							{important && <ImportantLabel />}
						</MobileMenuLink>
					))}
				</LinkBarDropdown>
			))}
		</>
	)
}

MobileMenu.propTypes = {
	...DesktopMenu.propTypes,
}
export default MobileMenu
