import React from 'react'
import styled from 'styled-components'

import { HorizontalLinkBar } from '@aller/shiny/src/molecules/HorizontalLinkBar'
import { LinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const BannerLink = styled.a`
	display: block;
	position: relative;
	height: 15rem;
	background: radial-gradient(
		circle at center,
		${getColor('splashBackground', 'light')} 0,
		${getColor('splashBackground')} 30rem
	);
	color: ${getColor('splashColor')};
`

// TODO: Swap this component for the logo
const Borsen = styled.div`
	position: absolute;
	bottom: 0;
	width: 100%;
	text-align: center;
	font-family: ${getVariable('headingsFont')};
	font-size: 11.4rem; /* ${getVariable('headingHugeSize')}; */
	line-height: 16.1rem; /*${getVariable('headingHugeLineHeight')}; */
	font-weight: ${getVariable('headingsWeight')};
	color: ${getColor('splashColor')};
`

const Header = styled.header`
	border-bottom: 0.1rem solid ${getColor('darkness', 'lighter')};
	box-shadow: 0 0 4rem 0 rgba(0, 0, 0, 0.15);
`

const LinkBar = styled(HorizontalLinkBar)`
	justify-content: center;
`

const Link = styled(LinkBarLink)`
	font-weight: ${getVariable('uiWeight')};
`

const linkProps = {
	useUnderline: false,
	ALLCAPS: true,
}

const BorsenHeader = () => {
	const a = 1
	return (
		<Header>
			<BannerLink href="//www.borsen.no">
				<Borsen>BØRSEN</Borsen>
			</BannerLink>
			<LinkBar backgroundColor="white" shouldFlexChildren>
				<Link {...linkProps} href="/">
					Forsiden
				</Link>
				<Link {...linkProps} href="/nyheter">
					Nyheter
				</Link>
				<Link {...linkProps} href="/kjendis">
					Kjendis
				</Link>
				<Link {...linkProps} href="/naeringsliv">
					Næringsliv
				</Link>
				<Link {...linkProps} href="/naeringsliv">
					Næringsliv
				</Link>
			</LinkBar>
		</Header>
	)
}

export default BorsenHeader
