import styled from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'

const Box = styled.div`
	margin: 0 0 ${getVariable('verticalBase')};
	padding: 0;
`
const Dl = styled(Box.withComponent('dl'))`
	list-style: none;
`
const Ul = Dl.withComponent('ul')

const Li = styled(Box.withComponent('li'))`
	margin: 0;
`
const Dd = styled(Li.withComponent('dd'))`
	width: 100%;
	float: left;
	clear: left;
	margin-bottom: calc(1 / 2 * ${getVariable('verticalBase')});
`
const Dt = styled(Dd.withComponent('dt'))`
	margin: 0;
	font-weight: 600;
`

const LogoLink = styled(BlockLink)`
	width: 100%;
	margin: 0 0 ${getVariable('verticalBase')};
	transition: 0.15s box-shadow;
	line-height: 0;
	box-shadow: none;

	&:hover,
	&:focus {
		box-shadow: 0 0 0 0.4rem ${getColor('primary')};
	}
`

const TipsOssButton = styled(Box.withComponent('a'))`
	display: inline-block;
	position: relative;
	padding: calc(1 / 2 * ${getVariable('verticalBase')}) 0;
	width: 100%;
	border-radius: 0.3rem;

	font-size: ${getVariable('uiLargeSize')};
	line-height: ${getVariable('uiLargeLineHeight')};
	font-family: ${getVariable('headingsFont')};
	letter-spacing: 0.1rem;
	font-weight: 700;
	text-decoration: none;
	text-align: center;
	text-transform: uppercase;

	background-color: ${getColor('primary')};
	color: ${getColor('white')};

	.tel {
		color: #222;
	}
`

const Link = styled.a`
	color: ${getColor('link')};
	text-decoration: underline;

	&:hover {
		text-decoration: none;
	}
	&:active {
		color: ${getColor('primary')};
	}
	&:focus {
		text-decoration: none;
	}
`

const Hide = styled.span`
	display: none;
`

const Footer = styled.footer`
	background: ${getColor('background')};
	color: ${getColor('type')};
	border-top: 0.1rem solid #ececec;
	padding: ${getVariable('verticalBase')} ${getVariable('horizontalBase')};
	font-size: ${getVariable('uiLargeSize')};
	line-height: ${getVariable('uiLargeLineHeight')};
`

export { Box, Footer, Ul, Li, Dl, Dd, Dt, Link, Hide, LogoLink, TipsOssButton }
