import React from 'react'
import dynamic from 'next/dynamic'
import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { Col } from '@aller/shiny/src/atoms/Col'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { LargeLinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'
import { VerticalFlexingList } from '@aller/shiny/src/atoms/VerticalFlexingList'
import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { Row } from '@aller/shiny/src/atoms/Row'

const ViLogo = dynamic(() =>
	import(/* webpackChunkName: "ViLogo" */ '@aller/shiny/src/atoms/ViLogo').then(c => c.ViLogo),
)

const ViGrid = styled(Grid)`
	@media screen and (min-width: ${p => p.theme.flexboxgrid.breakpoints.sm}em) {
		margin: 0;
		width: 100%;
	}
	@media screen and (min-width: ${p => p.theme.flexboxgrid.breakpoints.lg}em) {
		margin-left: auto;
		margin-right: auto;
		width: ${p => p.theme.flexboxgrid.breakpoints.lg}em;
	}
`

const LogoLink = styled(LargeLinkBarLink)`
	& {
		width: 10rem;
		padding: 0;
	}
`

const Footer = styled.footer`
	color: ${getColor('white')};
	background-color: ${getColor('primary')};
	padding: calc(${getVariable('verticalBase')} * 2) 0;
`

const Address = styled.address`
	font-size: ${getVariable('headingRegularSize')};
	font-weight: bold;
`

const ViLink = styled(BlockLink)`
	line-height: calc(${getVariable('uiRegularSize')} * 2);
	display: block;
	margin-bottom: 1.5rem;
	font-size: ${getVariable('headingMediumSize')};
	@media screen and (min-width: ${p => p.theme.flexboxgrid.breakpoints.md}em) {
		line-height: ${getVariable('headingMediumLineHeight')};
	}
	:hover {
		text-decoration: underline;
	}
`

const FooterList = styled(VerticalFlexingList)`
	display: block;
`

const Paragraph = styled.p`
	margin: 0;
	padding: 0;
`

const FooterBlock = styled(Col)`
	margin-bottom: calc(${getVariable('verticalBase')} / 0.8);
	@media screen and (min-width: ${p => p.theme.flexboxgrid.breakpoints.md}em) {
		margin-bottom: calc(${getVariable('verticalBase')} / 2);
		}
	}
`

const ViFooter = () => (
	<Footer>
		<ViGrid>
			<Row>
				<FooterBlock xs={12} sm={2}>
					<LogoLink href="https://www.vi.no">
						<ViLogo />
					</LogoLink>
				</FooterBlock>
				<FooterBlock xs={12} sm={4}>
					<Address>Besøksadresse:</Address>
					<ViLink fontSize="2rem" href="https://goo.gl/maps/EmpIH">
						Karvesvingen 1, 0579 Oslo
					</ViLink>
					<ViLink fontSize="1.8rem" href="https://facebook.com/vidotno">
						Følg oss på Facebook
					</ViLink>
				</FooterBlock>
				<FooterBlock xs={12} sm={3}>
					<FooterList>
						<ViLink href="https://www.vi.no/okonomi/redaksjonelle-retningslinjer-for-vino/69592512">
							Redaksjonelle retningslinjer
						</ViLink>
						<ViLink href="https://www.vi.no/okonomi/brukeravtale-for-vino/69591996">
							Debatt, personvern og cookies
						</ViLink>
						<ViLink href="https://personvern.aller.no/personvern.html">Personvernerklæring</ViLink>
						<ViLink href="https://www.vi.no/okonomi/kontakt-redaksjonen-i-vino/69563127">
							Kontakt redaksjonen i vi.no
						</ViLink>
						<ViLink href="https://personvern.aller.no/cookiepolicy.html">
							Om informasjonskapsler
						</ViLink>
						<ViLink color="yellow" href="http://annonse.aller.no/">
							Annonseinfo
						</ViLink>
					</FooterList>
				</FooterBlock>
				<FooterBlock xs={12} sm={3}>
					<Paragraph>
						Redaktør vi.no:
						<ViLink href="mailto:https://www.vi.no/mailto:andreas@dinside.no">
							Andreas Heen Carlsen
						</ViLink>
					</Paragraph>
					<Paragraph>
						Adm. dir. og ansvarlig redaktør:
						<ViLink href="mailto:jan.thoresen@aller.com">Jan Thoresen</ViLink>
					</Paragraph>
					<Paragraph>
						Utgiverselskap:
						<ViLink href="https://sol.no/">Scandinavia Online AS</ViLink>
					</Paragraph>
					<Paragraph>
						– et selskap i
						<ViLink href="https://www.aller.no/" display="inline">
							{' '}
							Aller Media
						</ViLink>
					</Paragraph>
				</FooterBlock>
			</Row>
		</ViGrid>
	</Footer>
)

export default ViFooter
