import React from 'react'
import dynamic from 'next/dynamic'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { Row } from '@aller/shiny/src/atoms/Row'
import { Col } from '@aller/shiny/src/atoms/Col'

import CouponLinks from '../CouponLinks'
import CtaPopup from '../CtaPopup'

import {
	Footer,
	Ul,
	Li,
	Dl,
	Dd,
	Dt,
	Link,
	Hide,
	LogoLink,
	TipsOssButton,
} from './footer-components'

const SeHerLogo = dynamic(() => import('@aller/shiny/src/atoms/SeHerLogo').then(c => c.SeHerLogo))

const SeherFooter = props => (
	<>
		<CtaPopup />
		<CouponLinks />
		<Footer itemType="http://schema.org/Organization" itemScope="" {...props}>
			<Grid>
				<Row>
					<Col xs={6} md lg={2}>
						<LogoLink itemProp="url" href="https://www.seher.no" title="Seher">
							<SeHerLogo />
							<Hide itemProp="name">Se og Hør</Hide>
						</LogoLink>
					</Col>
					<Col xs={6} md>
						<Dl>
							<Dt>Postadresse</Dt>
							<Dd itemProp="address" itemScope="" itemType="http://schema.org/PostalAddress">
								<span itemProp="postOfficeBoxNumber">Boks 1184</span> Sentrum,{' '}
								<span itemProp="postalCode">0107</span> <span itemProp="addressLocality">Oslo</span>
							</Dd>
							<Dt>Besøksadresse</Dt>
							<Dd itemProp="location" itemScope="" itemType="http://schema.org/PostalAddress">
								<Link href="https://goo.gl/maps/EmpIH">
									<span itemProp="streetAddress">Karvesvingen 1</span>,{' '}
									<span itemProp="postalCode">0579</span>{' '}
									<span itemProp="addressLocality">Oslo</span>
								</Link>
							</Dd>
							<Dt>Sentralbord</Dt>
							<Dd>
								<Link href="tel:+4721301000" itemProp="telephone">
									21 30 10 00
								</Link>
							</Dd>
						</Dl>
					</Col>
					<Col xs={6} md>
						<Dl>
							<div itemScope="" itemType="http://schema.org/Person">
								<Dt itemProp="jobTitle">Ansvarlig redaktør</Dt>
								<Dd>
									<Link href="mailto:ulf.andre.andersen@aller.com" itemProp="email">
										<span itemProp="name">Ulf André Andersen</span>
									</Link>
								</Dd>
							</div>
							<div itemScope="" itemType="http://schema.org/Person">
								<Dt itemProp="jobTitle">Redaktør seher.no</Dt>
								<Dd>
									<Link href="mailto:jonas@aller.no" itemProp="email">
										<span itemProp="name">Jonas Jørstad</span>
									</Link>
								</Dd>
							</div>
							<Dt>Utgiverselskap</Dt>
							<Dd>Aller Media AS</Dd>
							<Dt>Powered by</Dt>
							<Dd>Labrador CMS</Dd>
						</Dl>
					</Col>
					<Col xs={6} md>
						<TipsOssButton href="mailto:2255@shf.no">
							Tips oss på sms <span className="tel">2255</span>
						</TipsOssButton>
						<Ul>
							<Li>
								<Link href="http://annonse.dagbladet.no/">Annonseinfo</Link>
							</Li>
							<Li>
								<Link href="http://www.mediebedriftene.no/informasjonskapsler">
									Om informasjonskapsler
								</Link>
							</Li>
							<Li>
								<Link href="mailto:2255@shf.no">Redaksjonen</Link>
							</Li>
							<Li>
								<Link href="http://www.seher.no/personvern">Personvern</Link>
							</Li>
							<Li>
								<Link href="http://www.kk.no/rabattkoder">Rabattkoder</Link>
							</Li>
						</Ul>
					</Col>
				</Row>
			</Grid>
		</Footer>
	</>
)

export default SeherFooter
