import React from 'react'
import dynamic from 'next/dynamic'
import styled from 'styled-components'
import { Row } from '@aller/shiny/src/atoms/Row'
import { Col } from '@aller/shiny/src/atoms/Col'
import { getColor, getVariable } from '@aller/shiny/src/utils'
import { Heading } from '@aller/shiny/src/atoms/Heading'
import { VerticalFlexingList } from '@aller/shiny/src/atoms/VerticalFlexingList'
import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'

const StyledFooter = styled.footer`
	background-color: ${getColor('darkness', 'Light')};
	color: ${getColor('white')};
	font-size: ${getVariable('headingSmallSize')};
	line-height: ${getVariable('headingSmallLineHeight')};
	padding: ${getVariable('verticalBase')};
`

const SubCatHeading = styled(Heading)`
	font-weight: 500;
	margin: 0;
`

const NavLinksBar = styled(VerticalFlexingList)`
	display: block;
	list-style: none;
	margin: ${getVariable('headingRegularSize')} 0;
	line-height: ${getVariable('headingMediumSize')};
	padding: 0;
`

const DinsideLink = styled(BlockLink)`
	font-weight: 300;
	line-height: calc(${getVariable('uiRegularSize')} * 2);
`

const DinsideLinkYellow = styled(DinsideLink)`
	color: ${getColor('yellowDark')};
`

const Address = styled.address`
	font-style: normal;
`

const LogoCol = styled(Col)`
	text-align: center;
`
const InlineLogo = styled.div`
	display: inline-block;
	width: 10rem;
	margin: calc(${getVariable('uiRegularSize')} * 2);
`

const DinsideLogo = dynamic(() =>
	import(/* webpackChunkName: "DinsideLogo" */ '@aller/shiny/src/atoms/DinsideLogo').then(
		mod => mod.DinsideLogo,
	),
)

const DinsideFooter = () => (
	<StyledFooter>
		<Row center="sm">
			<LogoCol sm={3} xs={12}>
				<Row center="md">
					<Col md={12}>
						<InlineLogo>
							<DinsideLogo />
						</InlineLogo>
					</Col>
				</Row>
			</LogoCol>
			<Col sm={3} xs={12}>
				<Row>
					<Col xs={12}>
						<SubCatHeading size="small">Postadresse:</SubCatHeading>
						<Address>Boks 1184 Sentrum, 0107 Oslo</Address>
					</Col>
					<Col xs={12}>
						<SubCatHeading size="small">Besøksadresse:</SubCatHeading>
						<Address>
							<DinsideLink target="_blank" href="https://goo.gl/maps/EmpIH">
								Karvesvingen 1, 0579 Oslo
							</DinsideLink>
						</Address>
					</Col>
				</Row>
			</Col>
			<Col sm={3} xs={12}>
				<NavLinksBar>
					<DinsideLink href="//www.dinside.no/913551/redaksjonelle-retningslinjer-for-dinside">
						Redaksjonelle retningslinjer
					</DinsideLink>
					<DinsideLink href="https://personvern.aller.no/personvern.html">
						Personvernerklæring
					</DinsideLink>
					<DinsideLink href="mailto:webmaster@aller.no">Teknisk feil på nettsiden?</DinsideLink>
					<DinsideLink href="https://personvern.aller.no/cookiepolicy.html">
						Om informasjonskapsler
					</DinsideLink>
					<DinsideLinkYellow href="http://annonse.aller.no/">AnnonseInfo</DinsideLinkYellow>
				</NavLinksBar>
			</Col>
			<Col sm={3} xs={12}>
				<SubCatHeading size="small">Ansvarlig redaktør:</SubCatHeading>
				<DinsideLink href="mailto:abe@dagbladet.no">Alexandra Beverfjord</DinsideLink>
				<SubCatHeading size="small">Redaktør:</SubCatHeading>
				<DinsideLink href="mailto:bjorne@dinside.no">Bjørn Erik Loftås</DinsideLink>
				<SubCatHeading size="small">Utgiverselskap</SubCatHeading>
				<DinsideLink href="https://www.dagbladet.no">© 2019 Dagbladet</DinsideLink>
				Powered by Labrador CMS
			</Col>
		</Row>
	</StyledFooter>
)

export default DinsideFooter
