import React from 'react'
import styled, { css } from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { Col } from '@aller/shiny/src/atoms/Col'
import PropTypes from 'prop-types'
import { DagbladetLogo } from '@aller/shiny/src/atoms/DagbladetLogo'
import Row from '../GridRow'

const Footer = styled('footer')`
	background: ${getColor('footerBackground')};
	padding-top: 3rem;
	color: ${getColor('footerLinkColor')};
`

const TipsOssButton = styled('a')`
	background: ${getColor('primary')};
	color: ${getColor('white')};
	padding: 1rem 2rem 1.1rem;
	display: block;
	text-align: center;
	font-weight: 900;
	text-decoration: none;
	transition: 0.2s background;
	text-transform: uppercase;
	font-size: 1.3rem;
	display: inline-block;
	border-radius: 0.2rem;
	margin-bottom: 1.5rem;

	&:hover {
		background: ${getColor('primaryDark')};
	}
`

const DetailedList = styled('dl')`
	margin-bottom: 1.5rem;
	color: inherit;
	dt {
		font-weight: 900;
		display: block;
		line-height: 1.6;
	}
	dd {
		margin-bottom: 1.5rem;
		font-weight: 300;
	}
`
const LogoWrapper = styled('a')`
	height: auto;
	width: 14.4rem;
	display: block;
	margin-bottom: 1.5rem;
`
const Link = styled('a')`
	color: ${getColor('footerLinkColor')};
	text-decoration: none;
	font-weight: 300;
	line-height: 1.6;
	&:hover {
		text-decoration: underline;
	}
	${props =>
		props.arrow
			? css`
					&:after {
						content: ' ›';
					}
			  `
			: ''}
`
const Li = styled('li')`
	margin-bottom: 1.2rem;
`

const CopyrightContainer = styled('div')`
	background: ${getColor('footerBackgroundDarker')};
	text-align: center;
	margin-top: 1.5rem;
	padding: 1.5rem;
	line-height: 1.6;
	font-weight: 300;
`

const DagbladetFooter = ({ assignmentEditor }) => {
	const { name, email } = assignmentEditor
	const year = new Date().getFullYear()
	return (
		<Footer itemType="http://schema.org/Organization" itemScope="">
			<Row>
				<Col xs={12} md={4}>
					<LogoWrapper href="/" aria-label="Dagbladet logo">
						<DagbladetLogo width="inherit" height="inherit" />
					</LogoWrapper>
					<DetailedList>
						<dt>Postadresse:</dt>
						<dd itemProp="address" itemScope="" itemType="https://schema.org/PostalAddress">
							<span itemProp="postOfficeBoxNumber">Boks 1184</span> Sentrum,{' '}
							<span itemProp="postalCode">0107</span> <span itemProp="addressLocality">Oslo</span>
						</dd>
						<dt>Besøksadresse:</dt>

						<dd itemProp="location" itemScope="" itemType="https://schema.org/PostalAddress">
							<Link href="https://goo.gl/maps/EmpIH">
								<span itemProp="streetAddress">Karvesvingen 1</span>,{' '}
								<span itemProp="postalCode">0579</span> <span itemProp="addressLocality">Oslo</span>
							</Link>
						</dd>
						<dt>Sentralbord:</dt>
						<dd>
							<Link href="tel:+4724001000" itemProp="telephone">
								24 00 10 00
							</Link>
						</dd>
						<dt>Tilsynsorgan video:</dt>
						<dd>
							<Link href="https://www.medietilsynet.no/">Medietilsynet</Link>
						</dd>
					</DetailedList>
					<TipsOssButton href="//www.dagbladet.no/info/">tips oss 24 00 00 00</TipsOssButton>
				</Col>
				<Col xs={12} md={4}>
					<ul>
						<Li>
							<Link arrow href="https://kundeservice.dagbladet.no/hc/no">
								Kundeservice Pluss
							</Link>
						</Li>
						<Li>
							<Link
								arrow
								href="https://www.aller.no/om-aller/ledige-stillinger#_ga=2.96433625.491288559.1569821304-1425302315.1552399704"
							>
								Jobb i Dagbladet
							</Link>
						</Li>
						<Li>
							<Link arrow href="https://www.dagbladet.no/nyheter/dagbladets-husregler/66579649">
								Vær Varsom-plakaten
							</Link>
						</Li>
						<Li>
							<Link
								arrow
								href="https://www.dagbladet.no/nyheter/brukeravtale-for-dagbladetno/67454327"
							>
								Brukeravtale Dagbladet
							</Link>
						</Li>
						<Li>
							<Link
								arrow
								href="https://www.dagbladet.no/nyheter/abonnementvilkar-for-dagbladet-pluss/60248691"
							>
								Abonnementsvilkår Dagbladet Pluss
							</Link>
						</Li>
						<Li>
							<Link arrow href="https://personvern.aller.no/personvern.html">
								Personvernerklæring
							</Link>
						</Li>
						<Li>
							<Link arrow href="https://personvern.aller.no/cookiepolicy.html">
								Om informasjonskapsler
							</Link>
						</Li>
						<Li>
							<Link
								arrow
								href="https://annonse.aller.no/#_ga=2.101005508.491288559.1569821304-1425302315.1552399704"
							>
								Annonseinfo
							</Link>
						</Li>
						<Li>
							<Link arrow href="https://www.dagbladet.no/rabattkoder">
								Rabattkoder
							</Link>
						</Li>
						<Li>
							<Link arrow href="https://www.dagbladet.no/arkiv">
								Arkiv
							</Link>
						</Li>
					</ul>
				</Col>
				<Col xs={12} md={4}>
					<DetailedList itemScope itemType="https://schema.org/Person">
						<dt itemProp="jobTitle">Vaktsjef: </dt>
						<dd itemProp="email">
							<Link arrow href={`mailto:${email || '2400@dagbladet.no'}`}>
								<span itemProp="name">{name || 'Desken'}</span>
							</Link>
						</dd>

						<dt itemProp="jobTitle">Ansvarlig redaktør:</dt>
						<dd itemProp="email">
							<Link arrow href="mailto:abe@dagbladet.no">
								<span itemProp="name">Alexandra Beverfjord</span>
							</Link>
						</dd>

						<dt itemProp="jobTitle">Nyhetsredaktør:</dt>
						<dd itemProp="email">
							<Link arrow href="mailto:fha@dagbladet.no">
								<span itemProp="name">Frode Hansen</span>
							</Link>
						</dd>

						<dt itemProp="jobTitle">Politisk redaktør:</dt>
						<dd itemProp="email">
							<Link arrow href="mailto:ger@dagbladet.no">
								<span itemProp="name">Geir Ramnefjell</span>
							</Link>
						</dd>

						<dt itemProp="jobTitle">Kulturredaktør:</dt>
						<dd itemProp="email">
							<Link arrow href="mailto:shv@dagbladet.no">
								<span itemProp="name">Sigrid Hvidsten</span>
							</Link>
						</dd>

						<dt itemProp="jobTitle">Magasinredaktør:</dt>
						<dd itemProp="email">
							<Link arrow href="mailto:kos@dagbladet.no">
								<span itemProp="name">Katrine Østtveit</span>
							</Link>
						</dd>
					</DetailedList>
				</Col>
			</Row>
			<CopyrightContainer>© {year} Dagbladet | Powered by Labrador CMS</CopyrightContainer>
		</Footer>
	)
}

DagbladetFooter.propTypes = {
	assignmentEditor: PropTypes.shape({
		email: PropTypes.string.isRequired,
		name: PropTypes.string.isRequired,
	}),
}
DagbladetFooter.defaultProps = {
	assignmentEditor: {
		email: 'desken@dagbladet.no',
		name: 'Desken',
	},
}

export default DagbladetFooter
