import { NextPage } from 'next'

import { TrysilPlug } from '@aller/shiny/src/molecules/TrysilPlug'
import GridRow from '@aller/shared/components/GridRow'
import Row from '@aller/shared/components/Row'
import Col from '@aller/shared/components/Col'

type Props = {
	data: Data
}

type Data = object[]

const renderStructure = (child: any, outerMost = false) => {
	switch (child.type) {
		case 'Ad':
			return <Col xs={child.width}>Ad</Col>
		case 'Column':
			return <Col xs={child.width}>{child.row && renderStructure(child.row)}</Col>
		case 'Row':
			if (outerMost) {
				return <Row>{child.columns && child.columns.map((c: any) => renderStructure(c))}</Row>
			}
			return <GridRow>{child.columns && child.columns.map((c: any) => renderStructure(c))}</GridRow>
		case 'Article':
			return (
				<TrysilPlug
					column={{ xs: child.width }}
					title={child.title.map(titleSegment => titleSegment.text).join(' ')}
				/>
			)
		default:
			return null
	}
}

const XavierStructure: NextPage<Props> = ({ data = [] }: Props) => {
	const numberOfShownRows: number = 10
	return data.map(
		(row: any, i: number) =>
			i < numberOfShownRows && row.map((component: any) => renderStructure(component)),
	)
}

export default XavierStructure
