// Dependencies
import React from 'react'
import PropTypes from 'prop-types'
import dynamic from 'next/dynamic'

// Local components
import styled from 'styled-components'
import SkiStarPlug from '../SkiStarPlug'

const AdPrebid = dynamic(() => import(/* webpackChunkName: "AdPrebid" */ '../Ad/prebid'))

const FlexContainer = styled.div`
	display: flex;
	flex: 1;
	flex-shrink: 1;
	flex-grow: 1;
`

const grayPixel =
	'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAJCAYAAAA7KqwyAAAAF0lEQVR42mN8++b9fwYKAOOoAaMGAAEA4ukiCUCbW0cAAAAASUVORK5CYII=' // eslint-disable-line max-len

class Main extends React.Component {
	componentDidMount() {
		const { context } = this.props
		const { fetchContentAds } = context
		if (fetchContentAds) fetchContentAds()
	}

	render() {
		const {
			elementCounter,
			column,
			context: { contentAds },
		} = this.props

		if (!contentAds || !contentAds[elementCounter.contentAd]) {
			return (
				<AdPrebid id={`ad-medium-rectangle-perz${elementCounter.contentAd + 1}`} {...this.props} />
			)
		}

		// A placeholder is displayed before the content is loaded
		if (contentAds && !contentAds[0]) {
			return (
				<FlexContainer>
					<SkiStarPlug
						image={grayPixel}
						sources={[{ url: grayPixel }, { url: grayPixel }, { url: grayPixel }]}
						preventBlur
						ratio={9 / 16}
						secondaryTitle="secondaryTitle"
						url={undefined}
						ignoreDesktopGridFontsize
						key={`skistar-placeholder-${elementCounter.contentAd}`}
						isLoading
						maxsize
						column={column}
					/>
				</FlexContainer>
			)
		}

		// Show a medium rectangle if the serveAd property is true
		const article = contentAds[elementCounter.contentAd]
		if (!contentAds || article.serveAd || !article) {
			return (
				<AdPrebid id={`ad-medium-rectangle-perz${elementCounter.contentAd + 1}`} {...this.props} />
			)
		}

		// Show a content ad
		const imageSources = [
			{ url: `${article.cleanImage}&width=320&height=180`, media: '' },
			{
				url: `${article.cleanImage}&width=1024&height=576`,
				media: '(screen and min-width: 64em)',
			},
			{
				url: `${article.cleanImage}&width=640&height=360`,
				media: '(screen and min-width: 23em)',
			},
		]
		return (
			<FlexContainer>
				<SkiStarPlug
					preventBlur
					title={article.title}
					image={`${article.cleanImage}&width=320&height=180`}
					offset={400}
					ratio={9 / 16}
					url={article.url}
					key={`skistar-${elementCounter.contentAd}`}
					kicker="ANNONSØRINNHOLD"
					sources={imageSources}
					column={column}
					maxsize
					logoURL={article.logoURL}
					commercialPartner={article.commercialPartner}
					isNativeAdvertisement
					// subtitle={JSON.stringify(plugData)}
				/>
			</FlexContainer>
		)
	}
}

Main.propTypes = {
	elementCounter: PropTypes.shape({
		contentAd: PropTypes.number,
	}).isRequired,
	context: PropTypes.shape({
		fetchContentAds: PropTypes.func.isRequired,
		contentAds: PropTypes.arrayOf(PropTypes.shape({})),
	}),
	column: PropTypes.shape({}),
}

Main.defaultProps = {
	column: {},
	context: {},
}

export default Main
