// Dependencies
import React from 'react'
import PropTypes from 'prop-types'

// Local components
import SkiStarPlug from '../SkiStarPlug'

// ComponentadCounter
const Main = props => {
	const {
		context: { xavierarticles },
		counter,
		ratio,
		fontSizeOverride,
		column,
	} = props
	const article = xavierarticles[counter]

	if (!article) {
		return null
	}

	const imageSources = [
		{
			url: `${article.cleanImage}&width=1024&height=576`,
			media: '(min-width: 64em)',
		},
		{
			url: `${article.cleanImage}&width=640&height=360`,
			media: '(min-width: 23em)',
		},
		{ url: `${article.cleanImage}&width=320&height=180`, media: '' },
	]

	if (article.isMeninger) {
		article.dataLabel = 'meninger'
	}

	return (
		<SkiStarPlug
			preventBlur
			title={article.title}
			image={`${article.cleanImage}&width=320&height=180`}
			offset={400}
			bonusColumn
			fontSizeOverride={fontSizeOverride}
			ignoreDesktopGridFontsize
			ratio={ratio}
			url={article.url}
			labradorLabel={article.dataLabel}
			sources={imageSources}
			// subtitle={JSON.stringify(plugData)}
			column={column}
		/>
	)
}

Main.propTypes = {
	counter: PropTypes.number.isRequired,
	fontSizeOverride: PropTypes.number,
	ratio: PropTypes.number,
	context: PropTypes.arrayOf(PropTypes.shape({})),
	column: PropTypes.shape({}),
}

Main.defaultProps = {
	context: {},
	fontSizeOverride: 0,
	column: {},
	ratio: 0.5625,
}

export default Main
