import React from 'react'
import PropTypes from 'prop-types'
import SkiStarPlug from '../SkiStarPlug'

// b3b3b3, 16x9
const grayPixel =
	'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAJCAYAAAA7KqwyAAAAF0lEQVR42mN8++b9fwYKAOOoAaMGAAEA4ukiCUCbW0cAAAAASUVORK5CYII=' // eslint-disable-line max-len

const Loading = props => {
	const { column } = props
	return (
		<SkiStarPlug
			image={grayPixel}
			sources={[{ url: grayPixel }, { url: grayPixel }, { url: grayPixel }]}
			preventBlur
			ratio={9 / 16}
			secondaryTitle="secondaryTitle"
			url={undefined}
			isLoading
			column={column}
		/>
	)
}

Loading.propTypes = {
	context: PropTypes.shape({}),
	column: PropTypes.shape({}),
}

Loading.defaultProps = {
	context: {},
	column: {},
}

export default Loading
