import React from 'react'
import dynamic from 'next/dynamic'
import PropTypes from 'prop-types'

const VideoDymo = dynamic(() => import(/* webpackChunkName: "VideoDymo" */ './VideoDymo'))
const VideoFrontHeading = dynamic(() =>
	import(/* webpackChunkName: "VideoFrontHeading" */ './VideoFrontHeading'),
)
const VideoKicker = dynamic(() => import(/* webpackChunkName: "VideoKicker" */ './VideoKicker'))

const VideoHeading = ({ headingComponent, headingProps, text, ...rest }) => {
	let Heading
	switch (headingComponent) {
		case 'dymo':
			Heading = VideoDymo
			break
		case 'frontSmall':
			Heading = VideoFrontHeading
			break
		default:
			Heading = VideoKicker
			break
	}
	return (
		<Heading {...headingProps} {...rest}>
			{text || rest.children}
		</Heading>
	)
}

VideoHeading.propTypes = {
	headingComponent: PropTypes.string.isRequired,
	text: PropTypes.string,
	headingProps: PropTypes.shape({
		marginTopFactor: PropTypes.number,
	}),
}

VideoHeading.defaultProps = {
	text: '',
	headingProps: { marginTopFactor: 0 },
}

export default VideoHeading
