import styled, { css } from 'styled-components'
import { getVariable, getColor } from '@aller/shiny/src/utils'
import { Kicker } from '@aller/shiny/src/atoms/Kicker'

const BeforeHeading = props => {
	const {
		theme: { name },
	} = props

	switch (name) {
		case 'DinSide':
			return css`
				background-color: ${getColor('darkness')(props)};
				text-align: inherit;
				&:before {
					content: '//';
					color: ${getColor('yellow')(props)};
					margin-left: ${getVariable('horizontalBase')(props)};
				}
			`
		case 'KK':
			return css`
				font-family: ${getVariable('mainFont')(props)};
			`
		case 'Elbil24 Dark':
			return css`
				font-family: ${getVariable('mainFont')(props)};
				font-style: italic;
			`
		case 'SOL':
			return css`
				background-color: ${getColor('secondary')(props)};
			`
		default:
			return ''
	}
}

const VideoKicker = styled(Kicker)`
	font-family: ${getVariable('headingsFont')};
	margin-bottom: calc(${getVariable('verticalBase')} * 1 / 4);
	font-size: ${getVariable('headingSmallSize')};
	padding-left: ${getVariable('horizontalBase')};
	text-align: left;
	line-height: ${getVariable('headingSmallSize')};
	${BeforeHeading}
`

export default VideoKicker
