import styled, { css } from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { FrontSmallHeading } from '@aller/shiny/src/atoms/FrontHeading'

const headingStyles = props => {
	const {
		theme: { name },
	} = props

	const styles = `
		font-style: italic;
		text-transform: lowercase;
		::first-letter {
			text-transform: uppercase;
		}
	`

	switch (name) {
		case 'KK':
			return css`
				&& {
					font-size: ${getVariable('headingLargeSize')(props)};
					font-weight: 300;
					line-height: 2.9rem;
					${styles}
				}
			`
		case 'Elbil24 Dark':
			return css`
				&& {
					font-size: ${getVariable('headingRegularSize')(props)};
					@media (min-width: ${props.theme.flexboxgrid.breakpoints.md}em) {
						font-size: ${getVariable('headingLargeSize')(props)};
					}
					:after {
						border-bottom-width: 0.5rem;
					}
					${styles}
				}
			`
		case 'SOL':
			return css`
				&& {
					:after {
						border-bottom: 0.5rem solid ${getColor('secondary')(props)};
					}
				}
			`
		case 'Vi':
			return css`
				&& {
					font-size: ${getVariable('headingRegularSize')(props)};
					color: ${getColor('primary')(props)};
					font-weight: ${getVariable('headingsWeight')(props)};
				}
			`
		default:
			return ''
	}
}

const FrontHeading = styled(FrontSmallHeading)`
	${headingStyles}
`

export default FrontHeading
