// Dependencies
// import request from 'axios'
import unfetch from 'isomorphic-unfetch'
import fetchXavierCookieValue from '../../../utils/fetch-xavier-cookie-value'
import daily from '../dailyStatistic'
import weekly from '../weeklyStatistic'
// Export a function that returns
// a Promise of the data needed for
// the module.
export const getDailyData = options => Promise.resolve(daily.articles)
export const getWeeklyData = options => Promise.resolve(weekly.articles)

export default async ({ _dataOptions }) => {
	const cookie = fetchXavierCookieValue()
	const { site, statisticType } = _dataOptions
	const lookback = statisticType === 'daily' ? 1 : 7
	const url = `http://truesight-api.prod.medialaben.no/${site}/${cookie}/user?lookback=${lookback}`
	const response = await unfetch(url).catch(() => {})
	const data = await response.json().catch(() => {})
	return data.data || null
}
