import React from 'react'
import PropTypes from 'prop-types'
import styled, { withTheme } from 'styled-components'
import { VictoryPie } from 'victory-pie'
import { VictoryTooltip } from 'victory-tooltip'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { Row } from '@aller/shiny/src/atoms/Row'
import { Col } from '@aller/shiny/src/atoms/Col'
import { Heading as ShinyHeading } from '@aller/shiny/src/atoms/Heading'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import BackgroundScreen from './BackgroundScreen'
import { tagSummarizeSelector } from '../../utils/articleSelectors'

const Heading = styled(ShinyHeading)`
	color: ${p => getColor(p.color)};
	text-align: center;
`

const List = styled.ul`
	color: ${p => getColor(p.color)};
	text-shadow: 0.1rem 0.1rem 0.2rem ${getColor('type')};
	font-size: ${getVariable('headingLargeSize')};
	line-height: ${getVariable('headingLargeLineHeight')};
	text-align: left;
`

const Li = styled.li`
	&:before {
		content: '';
		display: inline-block;
		width: 1rem;
		height: 2rem;
		margin-right: 1rem;
		background-color: ${props => props.bgColor};
	}
`

const TagSum = withTheme(props => {
	const { data, visible } = props
	const { tagSummarize, coords, sortedKeys } = tagSummarizeSelector({
		articles: data.data,
		visible,
	})
	const tagSumCount = sortedKeys.length
	const sp = [
		'orange',
		'burgundy',
		'pink',
		'purple',
		'navy',
		'blue',
		'teal',
		'brown',
		'yellow',
		'sand',
		'green',
		'darkness',
	]

	const stackColors = sp.map(i => getColor(i)(props))
	return (
		<BackgroundScreen
			colors={['purple', 'blue']}
			backgroundImage="https://media.snl.no/system/images/18136/standard_Dagbladet.png"
			center
		>
			<Heading color="white" size="huge">
				Du har lest
			</Heading>
			<Grid>
				<Row around="xs" middle="xs">
					<Col md={4}>
						<List color="white">
							{sortedKeys.slice(0, 8).map((val, i) => (
								<Li bgColor={stackColors[i]} key={`${i}-${val}`}>
									{tagSummarize[val]} saker om
									{val}
								</Li>
							))}
						</List>
					</Col>
					<Col rowCount={tagSumCount} md={4}>
						<VictoryPie
							data={coords.slice(0, 8)}
							colorScale={stackColors}
							labelComponent={<VictoryTooltip />}
							labels={({ x, y }) => `${x} saker om ${y}`}
							radius={200}
							padding={0}
							style={{ labels: { fontSize: 25, padding: 20 }, parent: { padding: 0 } }}
						/>
					</Col>
				</Row>
			</Grid>
		</BackgroundScreen>
	)
})
TagSum.propTypes = {
	visible: PropTypes.number,
	data: PropTypes.shape({
		data: PropTypes.arrayOf(PropTypes.shape({ tags: PropTypes.arrayOf(PropTypes.string) })),
	}).isRequired,
}
TagSum.defaultProps = {
	visible: 8,
}
export default TagSum
