import PropTypes from 'prop-types'
import styled from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'
import Screen from '../Screen'

const imageColor = p => p.colors.map(color => getColor(color)(p)).join(',')

const BackgroundScreen = styled(Screen)`
	background: linear-gradient(${({ direct }) => direct}, ${imageColor});
	background-size: cover;
	background-blend-mode: normal, hard-light, normal;
`
BackgroundScreen.propTypes = {
	colors: PropTypes.arrayOf(PropTypes.string),
	imageColor: PropTypes.string,
	direct: PropTypes.string,
}
BackgroundScreen.defaultProps = {
	colors: ['darknessLight', 'blue'],
	direct: '120deg',
}

export default BackgroundScreen
