/* eslint-disable react/state-in-constructor */
import React from 'react'
import dynamic from 'next/dynamic'

import isClient from 'is-client'
import PercentagesOfPublished from '../PercentagesOfPublished'
import ListArticle from '../Catalog'

import UserProfile from './UserProfile'
import ArticlesReadStatistic from '../ArticlesReadStatistic'

const site = isClient() ? window.location.host : '' // window.location.host | www.seher.no

const UserInterests = dynamic(() =>
	import(/* webpackChunkName: "UserInterests" */ '../UserInterests'),
)
const UserTagSummary = dynamic(() =>
	import(/* webpackChunkName: "UserTagSummary" */ '../UserTagSummary'),
)

export default class UserSummary extends React.Component {
	state = {
		statisticType: 'daily',
	}

	changeStatisticType = e => {
		this.setState({ statisticType: e.currentTarget.attributes['data-value'].value })
	}

	render() {
		const { statisticType } = this.state
		const dataOptions = { site, statisticType }
		return (
			<>
				<UserProfile changeStatisticType={this.changeStatisticType} statisticType={statisticType} />
				<ArticlesReadStatistic _dataOptions={dataOptions} statisticType={statisticType} />
				<ListArticle _dataOptions={dataOptions} />
				<PercentagesOfPublished />
				<UserTagSummary _dataOptions={dataOptions} />
				<UserInterests _dataOptions={dataOptions} />
			</>
		)
	}
}
