import PropTypes from 'prop-types'
import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'

// Do you want to change the size?
// Change the font-size of the surrounding element.
const Shield = styled.span`
	position: relative;
	width: 1.4em;
	height: 1.2em;
	background-color: ${p => getColor(p.color)};
	border-radius: 0 0 1.4em 1.4em;
	display: inline-block;
	text-align: center;

	&:before,
	&:after {
		position: absolute;
		margin-top: 0.5em;
		content: '';
		left: 0.7em;
		top: 0;
		width: 0.7em;
		height: 0.85em;
		background: ${p => getColor(p.color)};
		border-radius: 1em 1em 0 0;
		transform: rotate(-60deg);
		transform-origin: 0 100%;
	}
	&:after {
		background-color: ${p => getColor(p.color)};
		left: 0;
		transform: rotate(60deg);
		transform-origin: 100% 100%;
	}
`
Shield.propTypes = {
	color: PropTypes.string,
}
Shield.defaultProps = {
	color: 'type',
}

export default Shield
