import PropTypes from 'prop-types'
import styled from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'
import Screen from '../Screen'

const backgroundColor = p => getColor(p.backgroundColor)(p)
const imageColor = p => getColor(p.imageColor)(p) || getColor(p.backgroundColor)(p)

const BackgroundScreen = styled(Screen)`
	background: radial-gradient(circle, transparent 0%, ${backgroundColor} 75%),
		linear-gradient(to right, ${imageColor}, ${imageColor}),
		url(${p => p.backgroundImage}) no-repeat center center;
	background-size: cover;
	background-blend-mode: normal, hard-light, normal;
`
BackgroundScreen.propTypes = {
	backgroundImage: PropTypes.string.isRequired,
	backgroundColor: PropTypes.string,
	imageColor: PropTypes.string,
}
BackgroundScreen.defaultProps = {
	backgroundColor: 'transparent',
	imageColor: 'transparent',
}

export default BackgroundScreen
