import React from 'react'
import styled from 'styled-components'

import { Paragraph } from '@aller/shiny/src/atoms/Paragraph'
import { Heading as ShinyHeading } from '@aller/shiny/src/atoms/Heading'
import { getColor } from '@aller/shiny/src/utils/get-color'

import Shield from './Shield'

const P = styled(Paragraph)`
	color: ${p => getColor(p.color)};
`
const Heading = styled(ShinyHeading)`
	color: ${p => getColor(p.color)};
`

const Achievements = () => (
	<div>
		<Heading color="white">Things you earned</Heading>
		<P color="white">
			<Shield color="yellow" /> Scanned the frontpage every weekday for a month.
		</P>
		<P color="white">
			<Shield color="grayTintLighter" /> You have visited seher.no at least 7 days in a row.
		</P>
		<P color="white">
			<Shield color="brownLighter" /> This weekend, you read more about utenriks than 90 % of our
			readers.
		</P>
	</div>
)

export default Achievements
