// Dependencies
import React from 'react'
import PropTypes from 'prop-types'

// Components for this module
import { DotLoader } from '@aller/shiny/src/atoms/loaders/DotLoader'
import Main from './Main'

// Decorators
import withData from '../../decorators/with-data'
// Services
import getData from './services/get-data'

// Our data fetching React component
const ExampleWithData = ({ isLoadingData, error, ...rest }) => {
	if (error) {
		return <div>Oops, something went wrong.</div>
	}
	if (isLoadingData) {
		return <DotLoader />
	}
	// The actual stuff you want to show
	return <Main {...rest} />
}
ExampleWithData.propTypes = {
	error: PropTypes.bool.isRequired,
	isLoadingData: PropTypes.bool.isRequired,
}

// Finally export the module
export const DailyInterests = withData({
	fetchData: getData, // getDailyData
	dataProp: 'data',
	loadingProp: 'isLoadingData',
})(ExampleWithData)

export const WeeklyInterests = withData({
	fetchData: getData, // getDailyData
	dataProp: 'data',
	loadingProp: 'isLoadingData',
})(ExampleWithData)

const Switcher = props => {
	const { _dataOptions } = props
	return _dataOptions.statisticType === 'daily' ? (
		<DailyInterests {...props} />
	) : (
		<WeeklyInterests {...props} />
	)
}
Switcher.propTypes = {
	_dataOptions: PropTypes.shape({ statisticType: PropTypes.string }).isRequired,
}

export default Switcher
