/* eslint-disable import/prefer-default-export */
import React from 'react'
import styled from 'styled-components'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

import { Box } from './Box'

const Container = styled.ul`
	margin-bottom: ${getVariable('horizontalBase')};
	width: 100%;
	display: grid;
	grid-template-columns: 100%;
	@media screen and (min-width: ${getVariable('largeWidth')}) {
		grid-template-columns: 28.7rem 28.7rem 28.7rem;
		grid-template-rows: 5.5rem 5.5rem 5.5rem 5.5rem;
		column-gap: 4.5rem;
		row-gap: 4.5rem;
	}
`

const boxList = [
	{
		title: 'Siste Nytt',
		link: 'https://sol.no/nyheter',
		bgColor1: '#FA0000',
		bgColor2: '#F55252',
	},
	{
		title: 'Sport',
		link: 'https://sol.no/sport',
		bgColor1: '#0FAA74',
		bgColor2: '#5DD5A8',
	},
	{
		title: 'Meninger',
		link: 'https://sol.no/meninger',
		bgColor1: '#007881',
		bgColor2: '#3599A1',
	},
	{
		title: 'Anbefalt',
		link: 'https://sol.no/redaksjonenanbefaler',
		bgColor1: '#830156',
		bgColor2: '#A0397C',
	},
	{
		title: 'Økonomi',
		link: 'https://sol.no/okonomi',
		bgColor1: '#FA0000',
		bgColor2: '#F55252',
	},
	{
		title: 'Underholdning',
		link: 'https://sol.no/underholdning',
		bgColor1: '#FF587C',
		bgColor2: '#FF8AA3',
	},
	{
		title: 'Motor',
		link: 'https://sol.no/motor',
		bgColor1: '#8E9298',
		bgColor2: '#CACCD0',
	},
	{
		title: 'Helse',
		link: 'https://sol.no/helse',
		bgColor1: '#5393F6',
		bgColor2: '#B6D1FC',
	},
	{
		title: 'Bolig',
		link: 'https://sol.no/bolig',
		bgColor1: '#9B673C',
		bgColor2: '#B99477',
	},
	{
		title: 'Mat',
		link: 'https://sol.no/mat',
		bgColor1: '#FF911E',
		bgColor2: '#F8BB7D',
	},
	{
		title: 'Forbrukertester',
		link: 'https://sol.no/tester',
		bgColor1: '#455B7D',
		bgColor2: '#7C8CA3',
	},
	{
		title: 'Reise',
		link: 'https://sol.no/reise',
		bgColor1: '#914AF7',
		bgColor2: '#C0A3F3',
	},
]

const Categories = () => {
	const boxes = boxList.map((item, index) => {
		return (
			<Box
				key={`box${index}`}
				title={item.title}
				link={item.link}
				bgColor1={item.bgColor1}
				bgColor2={item.bgColor2}
			/>
		)
	})
	return <Container>{boxes}</Container>
}

export { Categories }
