/* eslint-disable import/prefer-default-export, react/destructuring-assignment */

import React from 'react'
import propTypes from 'prop-types'
import styled from 'styled-components'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const Outer = styled.a`
	display: block;
	width: calc(100% - 3.6rem);
	height: 5.5rem;
	padding: 1.6rem 2rem;
	position: relative;
	box-shadow: 0 5px 14px 0 rgba(0, 0, 0, 0.1);
	background-image: linear-gradient(
		-90deg,
		${props => props.bgColor2} 0%,
		${props => props.bgColor1} 100%
	);
	background-color: ${props => props.bgColor2};
	border-radius: 5px;
	text-decoration: none;
	margin: 0 1.8rem 2rem;

	@media screen and (min-width: ${getVariable('largeWidth')}) {
		width: 100%;
		margin: 0;
	}
`

const Inner = styled.span`
	font-family: Montserrat-SemiBold, sans-serif;
	font-size: 1.6rem;
	color: #fff;
	letter-spacing: -0.16px;
	text-transform: uppercase;
`

const Box = props => {
	const { title, link, bgColor1, bgColor2 } = props

	return (
		<Outer bgColor1={bgColor1} bgColor2={bgColor2} href={link}>
			<Inner>{title}</Inner>
		</Outer>
	)
}
Box.propTypes = {
	title: propTypes.string.isRequired,
	link: propTypes.string.isRequired,
	bgColor1: propTypes.string.isRequired,
	bgColor2: propTypes.string.isRequired,
}

export { Box }
