import styled from 'styled-components'

import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'

interface Props {
	colorTheme: string
	isNativeAdvertisement?: boolean
	flexDirectionRow?: boolean
	useBoxShadow?: boolean
	target: string
	href: string
}

const PlugLink: React.FC<Props> = styled(BlockLink)`
	height: 100%;
	color: inherit;
	text-decoration: none;
	background: ${prop => {
		switch (prop.colorTheme) {
			case 'black':
				return '#222'
			case 'primary':
				return '#e20613'
			case 'yellow':
				return '#ffcb3b'
			case 'green':
				return '#1fa975'
			case 'secondary':
				return '#ececec'
			default:
				return '#fff'
		}
	}};
	display: block;
	display: flex;
	flex-flow: ${prop => (prop.flexDirectionRow ? 'row' : 'column')};
	box-shadow: ${prop => (prop.useBoxShadow ? '0 1px 4px -1px rgba(20, 20, 60, 0.08)' : '0')};
	z-index: 1;
	position: relative;
	&:hover {
		text-decoration: none;
	}

	${prop =>
		prop.isNativeAdvertisement &&
		`
			border-top: 3px solid;
			border-bottom: 3px solid;
			border-color: #23ACCC;
		`}
`

export default PlugLink
