import styled from 'styled-components'

import { LazyProgressiveImage } from '@aller/shiny/src/molecules/LazyProgressiveImage'

interface Props {
	ratio: number
	cloudinaryRatio?: number
	fadeIn: boolean
	preventBlur: boolean
	alt: string
	offset: number
	src: string
}

const Figure: React.FC<Props> = styled(LazyProgressiveImage)`
	&& {
		padding-bottom: ${p => p.ratio * 100}%;
		@media only screen and (max-width: 48em) {
			${p => p.cloudinaryRatio && 'padding-bottom: 50%'}
		}
		img {
			position: initial;
		}
	}
`

export default Figure
