import PropTypes from 'prop-types'
import styled from 'styled-components'
import { getColor, getVariable } from '@aller/shiny/src/utils'

const Description: any = styled.p`
	order: ${props => props.order};
	color: ${prop => {
		switch (prop.colorTheme) {
			case 'black':
			case 'primary':
			case 'green':
				return '#fff'
			case 'yellow':
			case 'secondary':
			default:
				return getColor('type')
		}
	}};
	font-size: ${getVariable('headingSmallSize')};
	line-height: ${getVariable('headingSmallLineHeight')};
	margin-top: 0;
	margin-bottom: 0.2rem;

	${prop => {
		switch (prop.md) {
			case 12:
			case 11:
			case 10:
			case 9:
				return `
					margin-top: 0.7rem;
					margin-bottom: 0.5rem;
				  `
			default:
				return `
					margin-top: 0;
					margin-bottom: 0.2rem;
				`
		}
	}}
`
Description.propTypes = {
	order: PropTypes.number,
}
Description.defaultProps = {
	order: 0,
}

export default Description
