import styled from 'styled-components'
import { Col } from '@aller/shiny/src/atoms/Col'
import { Article } from '@aller/shiny/src/atoms/Article'

const ArticleCol = Col.withComponent(Article)

export const SkistarArticle = styled(ArticleCol)`
	flex-shrink: 1;
	color: ${prop => {
		switch (prop.colorTheme) {
			case 'black':
			case 'primary':
			case 'green':
				return '#fff'
			case 'secondary':
			case 'yellow':
			default:
				return 'inherit'
		}
	}};
	margin-bottom: 1.4rem;

	@media only screen and (max-width: 600px) {
		width: 100%;
		margin-bottom: 1rem;
		padding-left: 0;
		padding-right: 0;
	}
`
export const SmallSkiStarArticle = styled(ArticleCol)`
	flex-shrink: 1;
	color: ${prop => {
		switch (prop.colorTheme) {
			case 'black':
			case 'primary':
				return '#fff'
			case 'yellow':
			case 'green':
			default:
				return 'inherit'
		}
	}};
	flex-direction: row;
	margin-bottom: 1rem;

	@media only screen and (max-width: 600px) {
		padding-left: 0;
		padding-right: 0;
	}
`

export default ArticleCol
