import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'

const Headline = styled.h1`
	font-family: 'Barlow', sans-serif;
	font-size: 2.4rem;
	line-height: 1.2;
	font-weight: 700;
	margin: 0;
	padding: 0 0 0.2em;

	.primary {
		color: ${getColor('solRed') || 'red'};
	}

	@media only screen and (min-width: 600px) {
		${prop => {
			if (!prop.fontSizeOverride || prop.fontSizeOverride === 0) {
				switch (prop.md) {
					case 12:
					case 11:
					case 10:
					case 9:
						return `
						font-size: 5.2rem;
						line-height: 1;
						font-weight: 800;
					`
					case 8:
					case 7:
						return `
						font-size: 4.2rem;
						line-height: 1;
						font-weight: 800;
					  `
					case 6:
					case 5:
						return `
						font-size: 3.2rem;
						line-height: 1;
						font-weight: 800;
					`
					case 4:
					case 3:
					case 2:
					case 1:
						return `
						font-size: 2.3rem;
						line-height: 1;
						font-weight: 600;
					`
					default:
						return `
						font-size: 3.2rem;
						line-height: 1;
						font-weight: 800;
					`
				}
			}
			return ''
		}}
	}

	@media only screen and (max-width: 600px) {
		background-color: transparent;
		line-height: 1.2;
		color: inherit;
		display: block;
		margin: 0;
		padding: 0 0 0.2em !important;

		${prop => {
			if (prop.fontSizeOverride === 0) {
				switch (prop.md) {
					case 12:
						return `
							font-size: ${prop.bonusColumn ? '5.5vw' : '5.867vw'};
							font-weight: ${prop.bonusColumn ? '700' : '800'};
						`
					case 4:
						return `
							font-size: ${prop.bonusColumn ? '5.5vw' : '5.867vw'};
							font-weight: ${prop.bonusColumn ? '700' : '800'};
						`
					default:
						return `
							font-size: ${prop.bonusColumn ? '5.5vw' : '5.867vw'};
							font-weight: ${prop.bonusColumn ? '700' : '800'};
						`
				}
			}
			return ''
		}}
	}
	${p => {
		return (
			p.fontSizeOverride !== 0 &&
			p.fontSizeOverride &&
			`font-size:${p.fontSizeOverride}rem!important`
		)
	}};
`
export default Headline
