import styled from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const Screen = styled.section`
	min-height: 85vh;
	padding: ${getVariable('verticalBase')} ${getVariable('horizontalBase')};
	overflow: hidden;
	background-color: ${({ color }) => getColor(color)};

	${({ center }) =>
		center &&
		`
		display: flex;
		flex-direction: column;
		justify-content: center;
		text-align: center;
	`}
`

export default Screen
