// Dependencies
// import request from 'axios'

const data = {
	site: 'seher.no',
	total: {
		published: 146,
		read: 9,
	},
	// Pick out the 'main tags'/sections for the site
	// Sort by number of published articles
	sections: [
		{
			title: 'nyheter',
			published: 57,
			read: 2,
		},
		{
			title: 'sport',
			published: 42,
			read: 5,
		},
		{
			title: 'underholdning',
			published: 28,
			read: 1,
		},
	],
	// Select the tag with most read articles,
	// select the tag with the most published articles,
	// exclude the 'main tags'/sections for the site
	tags: [
		{
			title: 'Ole Gunnar Solskjær',
			published: 3,
			read: 3,
		},
	],
}

// Export a function that returns
// a Promise of the data needed for
// the module.
export default function(options) {
	return Promise.resolve(data)
}
